package com.elitesland.cbpl.logging.common.domain;

import lombok.Getter;

/**
 * @author eric.hao
 * @since 2023/08/29
 */
@Getter
public enum ConsumerPipeline {

    /**
     * 消费方式
     */
    CONSOLE("本地控制台"),
    MYSQL("MySQL数据库"),
    ORACLE("Oracle数据库"),
    MONGO("MongoDB"),
    ES("Elasticsearch"),
    ROCKET_MQ("RocketMQ"),
    DISRUPTOR("内存队列"),
    STREAM("SpringCloud Stream"),
    CLOUDT("云梯架构解决方案"),
    ;

    private final String name;

    ConsumerPipeline(String name) {
        this.name = name;
    }

    public String getCode() {
        return name();
    }
}
