package com.elitesland.cbpl.logging.common.pipeline.es.service;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.common.constant.Prompt;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocDeleteParamVO;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.tool.es.repository.ElasticsearchRepository;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

import static com.elitesland.cbpl.tool.es.util.ElasticsearchUtil.indexNameByDay;

/**
 * @author eric.hao
 * @since 2024/01/30
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("ES")
public class ElasticsearchPipelineService implements PipelineService {

    @Resource
    private ElasticsearchRepository elasticRepository;

    @Override
    public boolean consume(LoggingProperty property, TrackDoc trackDoc) {
        try {
            // ES索引必填
            Assert.notBlank(property.getEsIndexName(), "【ES】日志索引(es-index-name)未配置");
            // 根据租户情况，按日期规则创建索引
            String indexName = getIndexName(property.getEsIndexName());
            // ES生命周期策略
            String policy = StrUtil.blankToDefault(property.getEsPolicyName(), "");
            if (elasticRepository.createIndex(indexName, policy, property.getEsIndexName())) {
                elasticRepository.insert(trackDoc, indexName);
            }
            return true;
        } catch (Throwable throwable) {
            logger.error("[PHOENIX-LOG] persistence es error", throwable);
        }
        return false;
    }

    @Override
    public PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        throw PhoenixException.unexpected(Prompt.NOT_SUPPORTED);
    }

    @Override
    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        throw PhoenixException.unexpected(Prompt.NOT_SUPPORTED);
    }

    @Override
    public long trackDocDelete(TrackDocDeleteParamVO paramVO) {
        throw PhoenixException.unexpected(Prompt.NOT_SUPPORTED);
    }

    @Override
    public List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query) {
        throw PhoenixException.unexpected(Prompt.NOT_SUPPORTED);
    }

    /**
     * 根据租户情况，按日期规则创建ES索引
     */
    private String getIndexName(String indexName) {
        String tenantCode = TenantSpiUtil.currentTenantCode();
        return StrUtil.isBlank(tenantCode) ? indexNameByDay(indexName) : indexNameByDay(indexName, tenantCode);
    }
}
