package com.elitesland.cbpl.logging.common.pipeline.mysql.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

import lombok.experimental.Accessors;
import lombok.Data;

import java.io.Serializable;

/**
 * 统一日志记录内容
 *
 * @author eric.hao
 * @since 2024/01/30
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "track_doc")
@org.hibernate.annotations.Table(appliesTo = "track_doc", comment = "统一日志记录内容")
@ApiModel("统一日志记录内容")
public class TrackDocDO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 536196191631368690L;

    /**
     * 链路ID
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "链路ID")
    @Column(name = "trace_id", nullable = true, length = 128)
    private String traceId;

    /**
     * 请求地址
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "请求地址")
    @Column(name = "request_url", nullable = true, length = 255)
    private String requestUrl;

    /**
     * 请求方式
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "请求方式")
    @Column(name = "request_method", nullable = true, length = 64)
    private String requestMethod;

    /**
     * 请求头信息
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "请求头信息")
    @Column(name = "request_header", nullable = true)
    private String requestHeader;

    /**
     * 请求参数：包含查询参数和表单参数
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "请求参数：包含查询参数和表单参数")
    @Column(name = "request_params", nullable = true)
    private String requestParams;

    /**
     * 请求体信息
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "请求体信息")
    @Column(name = "request_body", nullable = true)
    private String requestBody;

    /**
     * 请求返回信息，字符串类型
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "请求返回信息，字符串类型")
    @Column(name = "response_data", nullable = true)
    private String responseData;

    /**
     * 业务类型(自定义传值)
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "业务类型(自定义传值)")
    @Column(name = "track_type", nullable = true, length = 64)
    private String trackType;

    /**
     * 客户端IP
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "客户端IP")
    @Column(name = "address_ip", nullable = true, length = 128)
    private String addressIp;

    /**
     * 业务记录的日志
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "业务记录的日志")
    @Column(name = "event_message", nullable = true)
    private String eventMessage;

    /**
     * 业务记录的参数
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "业务记录的参数")
    @Column(name = "event_param", nullable = true)
    private String eventParam;

    /**
     * 错误信息
     * nullable : true
     * default  : null
     */
    @ApiModelProperty(value = "错误信息")
    @Column(name = "error_message", nullable = true)
    private String errorMessage;
}
