package com.elitesland.cbpl.logging.infinity.domain;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2024/07/09
 */
@Data
public class InfinityLogVO {

    // ======== Request ======== //

    @ApiModelProperty(value = "服务端地址")
    private String serverUrl;

    @ApiModelProperty(value = "接口地址")
    private String apiUrl;

    @ApiModelProperty(value = "接口完整地址")
    private String uri;

    @ApiModelProperty(value = "请求方式")
    private HttpMethod requestMethod;

    @ApiModelProperty(value = "header参数")
    private MultiValueMap<String, String> headerParam = new LinkedMultiValueMap<>();

    @ApiModelProperty(value = "查询参数")
    private MultiValueMap<String, String> queryParam = new LinkedMultiValueMap<>();

    @ApiModelProperty(value = "body参数")
    private Object bodyParam;

    @ApiModelProperty(value = "客户端IP")
    private String addressIp;

    // ======== Response ======== //

    @ApiModelProperty(value = "请求时间")
    private String requestTime;

    @ApiModelProperty(value = "响应时间")
    private String responseTime;

    @ApiModelProperty(value = "响应时长：单位毫秒")
    private Long spendTime;

    @ApiModelProperty(value = "是否请求成功")
    private Boolean requestSuccess;

    @ApiModelProperty(value = "请求失败信息")
    private String requestFailMessage;

    @ApiModelProperty(value = "响应体")
    private Object responseBody;

    @ApiModelProperty(value = "是否响应成功")
    private Boolean responseSuccess;

    @ApiModelProperty(value = "响应失败信息")
    private String responseFailMessage;

    // ======== Business Extension ======== //

    @ApiModelProperty(value = "日志链路ID")
    private String traceId;

    @ApiModelProperty(value = "外部应用名称")
    private String targetApp;

    @ApiModelProperty(value = "租户编码")
    private String tenantCode;

    @ApiModelProperty(value = "业务类型")
    private String businessType;

    @ApiModelProperty(value = "业务数据key")
    private String businessKey;

    // ======== param function ======== //

    public void addQueryParam(String name, Object... values) {
        Assert.notNull(name, "Name must not be null");
        if (!ObjectUtils.isEmpty(values)) {
            for (Object value : values) {
                String valueAsString = getQueryParamValue(value);
                this.queryParam.add(name, valueAsString);
            }
        } else {
            this.queryParam.add(name, null);
        }
    }

    @Nullable
    private String getQueryParamValue(@Nullable Object value) {
        if (value != null) {
            return (value instanceof Optional ?
                    ((Optional<?>) value).map(Object::toString).orElse(null) :
                    value.toString());
        }
        return null;
    }

    public void addQueryParams(@Nullable MultiValueMap<String, String> params) {
        if (params != null) {
            this.queryParam.addAll(params);
        }
    }
}
