/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.audit.annotation.aspect;

import com.elitesland.cbpl.logging.audit.annotation.AuditLog;
import com.elitesland.cbpl.logging.audit.annotation.aspect.AuditLogParse;
import com.elitesland.cbpl.logging.audit.context.AuditLogContext;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.tool.aop.AopAssistant;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.map.MapUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AuditLogHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogHandler.class);
    private final AuditLogParse auditLogParse;

    public void executeBeforeFunc(ProceedingJoinPoint joinPoint, Map<AuditLog, AuditLogVO> auditLogMap) {
        try {
            AuditLog[] annotations = (AuditLog[])AopAssistant.getAnnotations((JoinPoint)joinPoint, AuditLog.class);
            Function<AuditLog, Boolean> executeBeforeFunc = AuditLog::executeBeforeFunc;
            Arrays.stream(annotations).filter(executeBeforeFunc::apply).forEach(annotation -> {
                AuditLogVO auditLogVO = this.auditLogParse.resolve((AuditLog)annotation, (JoinPoint)joinPoint);
                MapUtils.putIfPresent((Map)auditLogMap, (Object)annotation, (Object)auditLogVO);
            });
        }
        catch (Throwable throwableBeforeFunc) {
            logger.error("[PHOENIX-AUDIT] around before function, error:", throwableBeforeFunc);
        }
    }

    public void executeAfterFunc(ProceedingJoinPoint joinPoint, Map<AuditLog, AuditLogVO> auditLogMap, Object result) {
        try {
            AuditLog[] annotations = (AuditLog[])AopAssistant.getAnnotations((JoinPoint)joinPoint, AuditLog.class);
            Function<AuditLog, Boolean> executeAfterFunc = annotation -> !annotation.executeBeforeFunc();
            AuditLogContext.putVariable("_return", result);
            Arrays.stream(annotations).filter(executeAfterFunc::apply).forEach(annotation -> {
                AuditLogVO auditLogVO = this.auditLogParse.resolve((AuditLog)annotation, (JoinPoint)joinPoint);
                MapUtils.putIfPresent((Map)auditLogMap, (Object)annotation, (Object)auditLogVO);
            });
            auditLogMap.forEach((annotation, auditLog) -> {
                if (auditLog.getSuccess() == null) {
                    auditLog.setSuccess(true);
                }
                if (annotation.recordReturnValue() && result != null) {
                    auditLog.setReturnStr(BeanUtils.toJsonStr((Object)result));
                }
            });
        }
        catch (Throwable throwableAfterFuncSuccess) {
            logger.error("[PHOENIX-AUDIT] around after function success, error:", throwableAfterFuncSuccess);
        }
    }

    public void executeException(ProceedingJoinPoint joinPoint, Map<AuditLog, AuditLogVO> auditLogMap, Throwable throwable) {
        try {
            AuditLog[] annotations = (AuditLog[])AopAssistant.getAnnotations((JoinPoint)joinPoint, AuditLog.class);
            Function<AuditLog, Boolean> executeAfterFunc = annotation -> !annotation.executeBeforeFunc();
            AuditLogContext.putVariable("_errorMsg", throwable.getMessage());
            Arrays.stream(annotations).filter(executeAfterFunc::apply).forEach(annotation -> {
                AuditLogVO auditLogVO = this.auditLogParse.resolve((AuditLog)annotation, (JoinPoint)joinPoint);
                MapUtils.putIfPresent((Map)auditLogMap, (Object)annotation, (Object)auditLogVO);
            });
            auditLogMap.forEach((annotation, auditLog) -> {
                auditLog.setSuccess(false);
                auditLog.setException(throwable.getMessage());
            });
        }
        catch (Throwable throwableAfterFuncFailure) {
            logger.error("[PHOENIX-AUDIT] around after function failure, error:", throwableAfterFuncFailure);
        }
    }

    public AuditLogHandler(AuditLogParse auditLogParse) {
        this.auditLogParse = auditLogParse;
    }
}

