/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.common.util;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.unicom.util.UnicomClient;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConfigUtil {
    private static final Logger logger = LoggerFactory.getLogger(LogConfigUtil.class);

    public static void configIntegrity(LoggingProperty property) {
        if (ObjectUtil.isNull((Object)property) || ObjectUtil.isNull((Object)((Object)property.getLogType()))) {
            throw PhoenixException.unchecked((String)("[LOG] \u65e5\u5fd7\u7c7b\u578b\u672a\u6b63\u786e\u914d\u7f6e\uff1a" + BeanUtils.toJsonStr((Object)property)));
        }
        if (ObjectUtil.isNull((Object)((Object)property.getConsumerPipeline()))) {
            throw PhoenixException.unchecked((String)("[LOG] \u65e5\u5fd7\u6d88\u8d39\u65b9\u5f0f\u672a\u6307\u5b9a\uff1a" + BeanUtils.toJsonStr((Object)property)));
        }
        String logType = property.getLogType().getCode();
        if (!property.isEnabled()) {
            throw PhoenixException.unchecked((String)("[LOG] \u65e5\u5fd7\u529f\u80fd\u672a\u5f00\u542f\uff1a" + logType));
        }
    }

    public static String pipeline(LoggingProperty property) {
        LogConfigUtil.configIntegrity(property);
        return property.getConsumerPipeline().getCode();
    }

    public static <T> T supply(Supplier<T> executor, LoggingProperty property) {
        return (T)UnicomClient.supply(executor, (String)LogConfigUtil.pipeline(property));
    }
}

