package com.elitesland.cbpl.logging.common.pipeline.mongo.service;

import cn.hutool.core.collection.ListUtil;
import com.elitesland.cbpl.common.constant.Prompt;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocDeleteParamVO;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.common.pipeline.mongo.convert.TrackMongoConvert;
import com.elitesland.cbpl.logging.common.pipeline.mongo.domain.MongoAuditQuery;
import com.elitesland.cbpl.logging.common.pipeline.mongo.domain.MongoTrackDoc;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.tool.mongo.repository.MongoStorer;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2024/02/01
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("MONGO")
public class MongoPipelineService implements PipelineService {

    @Autowired(required = false)
    private MongoStorer mongoStorer;
    @Autowired(required = false)
    private MongoTemplate mongoTemplate;

    @Override
    public boolean consume(LoggingProperty property, TrackDoc trackDoc) {
        if (mongoStorer == null) {
            logger.error("[PHOENIX-LOG] MongoDB Incorrect configuration.");
            return false;
        }
        try {
            MongoTrackDoc doc = TrackMongoConvert.INSTANCE.toSaveDoc(trackDoc);
            doc.setType(property.getLogType());
            mongoStorer.save(doc, property.getMongoStoreName());
            return true;
        } catch (Throwable throwable) {
            logger.error("[PHOENIX-LOG] persistence mongodb error", throwable);
        }
        return false;
    }

    @Override
    public PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        throw PhoenixException.unexpected(Prompt.NOT_SUPPORTED);
    }

    @Override
    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        throw PhoenixException.unexpected(Prompt.NOT_SUPPORTED);
    }

    @Override
    public long trackDocDelete(TrackDocDeleteParamVO paramVO) {
        throw PhoenixException.unexpected(Prompt.NOT_SUPPORTED);
    }

    @Override
    public List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query) {
        if (mongoTemplate == null) {
            logger.error("[PHOENIX-LOG] MongoDB Incorrect configuration.");
            return ListUtil.empty();
        }
        var result = MongoAuditQuery.builder().params(query)
                .build().find(mongoTemplate, MongoTrackDoc.class);
        return result.stream().map(MongoTrackDoc::getEventParam)
                .map(row -> BeanUtils.toBean(row, AuditLogVO.class)).collect(Collectors.toList());
    }
}
