package com.elitesland.cbpl.logging.common.pipeline.mysql.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocDeleteParamVO;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.pipeline.mysql.entity.QTrackDocDO;
import com.querydsl.core.types.*;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/01/30
 */
@Component
@RequiredArgsConstructor
public class MysqlTrackDocRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QTrackDocDO trackDocDO = QTrackDocDO.trackDocDO;

    private final QBean<TrackDocRespVO> trackDocPagingVO = Projections.bean(
            TrackDocRespVO.class,
            trackDocDO.id,
            trackDocDO.traceId,
            trackDocDO.requestUrl,
            trackDocDO.requestMethod,
            trackDocDO.requestHeader,
            trackDocDO.requestParams,
            trackDocDO.requestBody,
            trackDocDO.responseData,
            trackDocDO.trackType,
            trackDocDO.addressIp,
            trackDocDO.eventMessage,
            trackDocDO.eventParam,
            trackDocDO.errorMessage,
            trackDocDO.remark,
            trackDocDO.createUserId,
            trackDocDO.creator,
            trackDocDO.createTime,
            trackDocDO.modifyUserId,
            trackDocDO.updater,
            trackDocDO.modifyTime,
            trackDocDO.deleteFlag
    );

    private Predicate pagingWhere(TrackDocQueryParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(trackDocDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getId())) {
            predicates.add(trackDocDO.id.eq(query.getId()));
        }
        if (StrUtil.isNotBlank(query.getTraceId())) {
            predicates.add(trackDocDO.traceId.eq(query.getTraceId()));
        }
        if (StrUtil.isNotBlank(query.getRequestUrl())) {
            predicates.add(trackDocDO.requestUrl.eq(query.getRequestUrl()));
        }
        if (StrUtil.isNotBlank(query.getRequestMethod())) {
            predicates.add(trackDocDO.requestMethod.eq(query.getRequestMethod()));
        }
        if (StrUtil.isNotBlank(query.getRequestHeader())) {
            predicates.add(trackDocDO.requestHeader.eq(query.getRequestHeader()));
        }
        if (StrUtil.isNotBlank(query.getRequestParams())) {
            predicates.add(trackDocDO.requestParams.eq(query.getRequestParams()));
        }
        if (StrUtil.isNotBlank(query.getRequestBody())) {
            predicates.add(trackDocDO.requestBody.eq(query.getRequestBody()));
        }
        if (StrUtil.isNotBlank(query.getResponseData())) {
            predicates.add(trackDocDO.responseData.eq(query.getResponseData()));
        }
        if (StrUtil.isNotBlank(query.getTrackType())) {
            predicates.add(trackDocDO.trackType.eq(query.getTrackType()));
        }
        if (StrUtil.isNotBlank(query.getAddressIp())) {
            predicates.add(trackDocDO.addressIp.eq(query.getAddressIp()));
        }
        if (StrUtil.isNotBlank(query.getEventMessage())) {
            predicates.add(trackDocDO.eventMessage.eq(query.getEventMessage()));
        }
        if (StrUtil.isNotBlank(query.getEventParam())) {
            predicates.add(trackDocDO.eventParam.eq(query.getEventParam()));
        }
        if (StrUtil.isNotBlank(query.getErrorMessage())) {
            predicates.add(trackDocDO.errorMessage.eq(query.getErrorMessage()));
        }
        if (StrUtil.isNotBlank(query.getRemark())) {
            predicates.add(trackDocDO.remark.eq(query.getRemark()));
        }
        if (ObjectUtil.isNotNull(query.getCreateUserId())) {
            predicates.add(trackDocDO.createUserId.eq(query.getCreateUserId()));
        }
        if (StrUtil.isNotBlank(query.getCreator())) {
            predicates.add(trackDocDO.creator.eq(query.getCreator()));
        }
        if (ObjectUtil.isNotNull(query.getCreateTime())) {
            predicates.add(trackDocDO.createTime.eq(query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull(query.getModifyUserId())) {
            predicates.add(trackDocDO.modifyUserId.eq(query.getModifyUserId()));
        }
        if (StrUtil.isNotBlank(query.getUpdater())) {
            predicates.add(trackDocDO.updater.eq(query.getUpdater()));
        }
        if (ObjectUtil.isNotNull(query.getModifyTime())) {
            predicates.add(trackDocDO.modifyTime.eq(query.getModifyTime()));
        }
        if (ObjectUtil.isNotNull(query.getDeleteFlag())) {
            predicates.add(trackDocDO.deleteFlag.eq(query.getDeleteFlag()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long trackDocCountBy(TrackDocQueryParamVO query) {
        var jpaQuery = jpaQueryFactory.select(trackDocDO.id)
                .from(trackDocDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        var jpaQuery = jpaQueryFactory.select(trackDocPagingVO)
                .from(trackDocDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, trackDocDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private final QBean<TrackDocRespVO> trackDocVO = Projections.bean(
            TrackDocRespVO.class,
            trackDocDO.id,
            trackDocDO.traceId,
            trackDocDO.requestUrl,
            trackDocDO.requestMethod,
            trackDocDO.requestHeader,
            trackDocDO.requestParams,
            trackDocDO.requestBody,
            trackDocDO.responseData,
            trackDocDO.trackType,
            trackDocDO.addressIp,
            trackDocDO.eventMessage,
            trackDocDO.eventParam,
            trackDocDO.errorMessage,
            trackDocDO.remark,
            trackDocDO.createUserId,
            trackDocDO.creator,
            trackDocDO.createTime,
            trackDocDO.modifyUserId,
            trackDocDO.updater,
            trackDocDO.modifyTime,
            trackDocDO.deleteFlag
    );

    private Predicate where(TrackDocQueryParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(trackDocDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getId())) {
            predicates.add(trackDocDO.id.eq(query.getId()));
        }
        if (StrUtil.isNotBlank(query.getTraceId())) {
            predicates.add(trackDocDO.traceId.eq(query.getTraceId()));
        }
        if (StrUtil.isNotBlank(query.getRequestUrl())) {
            predicates.add(trackDocDO.requestUrl.eq(query.getRequestUrl()));
        }
        if (StrUtil.isNotBlank(query.getRequestMethod())) {
            predicates.add(trackDocDO.requestMethod.eq(query.getRequestMethod()));
        }
        if (StrUtil.isNotBlank(query.getRequestHeader())) {
            predicates.add(trackDocDO.requestHeader.eq(query.getRequestHeader()));
        }
        if (StrUtil.isNotBlank(query.getRequestParams())) {
            predicates.add(trackDocDO.requestParams.eq(query.getRequestParams()));
        }
        if (StrUtil.isNotBlank(query.getRequestBody())) {
            predicates.add(trackDocDO.requestBody.eq(query.getRequestBody()));
        }
        if (StrUtil.isNotBlank(query.getResponseData())) {
            predicates.add(trackDocDO.responseData.eq(query.getResponseData()));
        }
        if (StrUtil.isNotBlank(query.getTrackType())) {
            predicates.add(trackDocDO.trackType.eq(query.getTrackType()));
        }
        if (StrUtil.isNotBlank(query.getAddressIp())) {
            predicates.add(trackDocDO.addressIp.eq(query.getAddressIp()));
        }
        if (StrUtil.isNotBlank(query.getEventMessage())) {
            predicates.add(trackDocDO.eventMessage.eq(query.getEventMessage()));
        }
        if (StrUtil.isNotBlank(query.getEventParam())) {
            predicates.add(trackDocDO.eventParam.eq(query.getEventParam()));
        }
        if (StrUtil.isNotBlank(query.getErrorMessage())) {
            predicates.add(trackDocDO.errorMessage.eq(query.getErrorMessage()));
        }
        if (StrUtil.isNotBlank(query.getRemark())) {
            predicates.add(trackDocDO.remark.eq(query.getRemark()));
        }
        if (ObjectUtil.isNotNull(query.getCreateUserId())) {
            predicates.add(trackDocDO.createUserId.eq(query.getCreateUserId()));
        }
        if (StrUtil.isNotBlank(query.getCreator())) {
            predicates.add(trackDocDO.creator.eq(query.getCreator()));
        }
        if (ObjectUtil.isNotNull(query.getCreateTime())) {
            predicates.add(trackDocDO.createTime.eq(query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull(query.getModifyUserId())) {
            predicates.add(trackDocDO.modifyUserId.eq(query.getModifyUserId()));
        }
        if (StrUtil.isNotBlank(query.getUpdater())) {
            predicates.add(trackDocDO.updater.eq(query.getUpdater()));
        }
        if (ObjectUtil.isNotNull(query.getModifyTime())) {
            predicates.add(trackDocDO.modifyTime.eq(query.getModifyTime()));
        }
        if (ObjectUtil.isNotNull(query.getDeleteFlag())) {
            predicates.add(trackDocDO.deleteFlag.eq(query.getDeleteFlag()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        var jpaQuery = jpaQueryFactory.select(trackDocVO)
                .from(trackDocDO);
        jpaQuery.where(this.where(query));
        // 按时间倒序
        jpaQuery.orderBy(new OrderSpecifier<>(Order.DESC, trackDocDO.createTime));
        return jpaQuery.fetch();
    }

    public long trackDocDelete(TrackDocDeleteParamVO paramVO) {
        if (paramVO.isEmpty()) {
            return 0L;
        }
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(trackDocDO.deleteFlag.eq(0));
        if (CollUtil.isNotEmpty(paramVO.getTraceIds())) {
            predicates.add(trackDocDO.traceId.in(paramVO.getTraceIds()));
        }
        if (ObjectUtil.isNotNull(paramVO.getBeforeTime())) {
            predicates.add(trackDocDO.createTime.lt(paramVO.getBeforeTime()));
        }
        var jpaQuery = jpaQueryFactory.delete(trackDocDO)
                .where(ExpressionUtils.allOf(predicates));
        return jpaQuery.execute();
    }
}
