package com.elitesland.cbpl.logging.common.service;

import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.tool.core.http.RequestWrapper;
import com.elitesland.cbpl.unicom.annotation.Unicom;

import java.util.List;

import static com.elitesland.cbpl.tool.core.http.HttpServletUtil.currentRequestWrapper;

/**
 * @author eric.hao
 * @since 2023/08/28
 */
@Unicom
public interface PersistenceService {

    /**
     * 日志持久化操作 - 多条记录分开存储
     *
     * @param property     日志统一配置
     * @param trackType    业务类型(自定义传值)
     * @param eventMessage 业务记录的日志
     * @param eventParam   业务参数(多条)
     * @param eventError   报错日志
     */
    <T> void addSystemLogs(LoggingProperty property, String trackType, String eventMessage, List<T> eventParam, String eventError);

    /**
     * 日志持久化操作
     *
     * @param property     日志统一配置
     * @param trackType    业务类型(自定义传值)
     * @param eventMessage 业务记录的日志
     */
    default void addSystemLog(LoggingProperty property, String trackType, String eventMessage) {
        addSystemLog(property, currentRequestWrapper(), eventMessage, trackType, null, null);
    }

    /**
     * 日志持久化操作
     *
     * @param property     日志统一配置
     * @param trackType    业务类型(自定义传值)
     * @param eventMessage 业务记录的日志
     * @param eventParam   业务参数
     * @param eventError   报错日志
     */
    default <T> void addSystemLog(LoggingProperty property, String trackType, String eventMessage, T eventParam, String eventError) {
        addSystemLog(property, currentRequestWrapper(), trackType, eventMessage, eventParam, eventError);
    }

    /**
     * 日志持久化操作
     *
     * @param property     日志统一配置
     * @param request      客户端请求
     * @param trackType    业务类型(自定义传值)
     * @param eventMessage 业务记录的日志
     * @param eventParam   业务参数
     * @param eventError   报错日志
     */
    <T> void addSystemLog(LoggingProperty property, RequestWrapper request, String trackType, String eventMessage, T eventParam, String eventError);
}
