package com.elitesland.cbpl.logging.syslog.service;

import com.elitesland.cbpl.logging.common.domain.TrackType;

/**
 * 系统日志
 *
 * @author eric.hao
 * @since 2023/06/13
 */
public interface SysLogService {

    /**
     * 系统日志
     *
     * @param trackType  业务类型(自定义传值)
     * @param message    执行日志
     * @param eventParam 业务参数
     */
    void info(String trackType, String message, Object eventParam);

    /**
     * 错误日志
     *
     * @param trackType  业务类型(自定义传值)
     * @param message    执行日志
     * @param eventParam 业务参数
     * @param ex         异常错误
     */
    void error(String trackType, String message, Object eventParam, Throwable ex);

    /**
     * 错误日志 - 自定义报错内容
     *
     * @param trackType      业务类型(自定义传值)
     * @param message        执行日志
     * @param eventParam     业务参数
     * @param trackTypeError 报错日志
     */
    void error(String trackType, String message, Object eventParam, String trackTypeError);

    /**
     * 系统日志
     *
     * @param message 执行日志
     */
    default void info(String message) {
        info(TrackType.LOG_SYSTEM.getCode(), message, null);
    }

    /**
     * 系统日志
     *
     * @param message    执行日志
     * @param eventParam 业务参数
     */
    default void info(String message, Object eventParam) {
        info(TrackType.LOG_SYSTEM.getCode(), message, eventParam);
    }

    /**
     * 错误日志
     *
     * @param message    执行日志
     * @param eventParam 业务参数
     * @param ex         异常错误
     */
    default void error(String message, Object eventParam, Throwable ex) {
        error(TrackType.LOG_SYSTEM.getCode(), message, eventParam, ex);
    }

    /**
     * 错误日志 - 自定义报错内容
     *
     * @param message        执行日志
     * @param eventParam     业务参数
     * @param trackTypeError 报错日志
     */
    default void error(String message, Object eventParam, String trackTypeError) {
        error(TrackType.LOG_SYSTEM.getCode(), message, eventParam, trackTypeError);
    }
}
