package com.elitesland.cbpl.logging.syslog.service;

import com.elitesland.cbpl.logging.common.service.PersistenceService;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.cbpl.logging.common.config.LoggingProperties.LOG_SYSLOG_CFG;

/**
 * @author eric.hao
 * @since 2023/06/13
 */
@Service
@RequiredArgsConstructor
public class SysLogServiceImpl implements SysLogService {

    private final PersistenceService persistenceService;

    @Override
    public void info(String trackType, String message, Object eventParam) {
        persistenceService.addSystemLog(LOG_SYSLOG_CFG, trackType, message, eventParam, "");
    }

    @Override
    public void error(String trackType, String message, Object eventParam, Throwable ex) {
        persistenceService.addSystemLog(LOG_SYSLOG_CFG, trackType, message, eventParam, ExceptionUtils.formatException(ex));
    }

    @Override
    public void error(String trackType, String message, Object eventParam, String trackTypeError) {
        persistenceService.addSystemLog(LOG_SYSLOG_CFG, trackType, message, eventParam, trackTypeError);
    }
}
