package com.elitesland.cbpl.logging.syslog.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.logging.syslog.service.SysLogService;
import com.elitesland.cbpl.logging.syslog.service.SysLogServiceImpl;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * 系统日志 - 工具类
 *
 * @author eric.hao
 * @since 2023/08/17
 */
@Slf4j
@NoArgsConstructor
public class LogUtil {

    private static SysLogService sysLogService;

    private static SysLogService getInstance() {
        if (sysLogService == null) {
            sysLogService = SpringUtil.getBean(SysLogServiceImpl.class);
        }
        return sysLogService;
    }

    /**
     * 系统日志
     *
     * @param message 执行日志
     */
    public static void info(String message) {
        getInstance().info(message);
    }

    /**
     * 系统日志
     *
     * @param message 执行日志
     * @param param   业务参数
     */
    public static void info(String message, Object param) {
        getInstance().info(message, param);
    }

    /**
     * 错误日志
     *
     * @param message 执行日志
     */
    public static void error(String message) {
        getInstance().error(message, null, "");
    }

    /**
     * 错误日志
     *
     * @param message        执行日志
     * @param trackTypeError 报错日志
     */
    public static void error(String message, String trackTypeError) {
        getInstance().error(message, null, trackTypeError);
    }

    /**
     * 错误日志
     *
     * @param message 执行日志
     * @param ex      异常错误
     */
    public static void error(String message, Throwable ex) {
        getInstance().error(message, null, ex);
    }

    /**
     * 错误日志
     *
     * @param message 执行日志
     * @param param   业务参数
     * @param ex      异常错误
     */
    public static void error(String message, Object param, Throwable ex) {
        getInstance().error(message, param, ex);
    }

    /**
     * 错误日志 - 自定义报错内容
     *
     * @param message        执行日志
     * @param param          业务参数
     * @param trackTypeError 报错日志
     */
    public static void error(String message, Object param, String trackTypeError) {
        getInstance().error(message, param, trackTypeError);
    }

    /**
     * 系统日志
     *
     * @param trackType 业务类型(自定义传值)
     * @param message   执行日志
     * @param param     业务参数
     */
    public static void info(String trackType, String message, Object param) {
        getInstance().info(trackType, message, param);
    }

    /**
     * 错误日志
     *
     * @param trackType 业务类型(自定义传值)
     * @param message   执行日志
     * @param param     业务参数
     * @param ex        异常错误
     */
    public static void error(String trackType, String message, Object param, Throwable ex) {
        getInstance().error(trackType, message, param, ex);
    }

    /**
     * 错误日志 - 自定义报错内容
     *
     * @param trackType      业务类型(自定义传值)
     * @param message        执行日志
     * @param param          业务参数
     * @param trackTypeError 报错日志
     */
    public static void error(String trackType, String message, Object param, String trackTypeError) {
        getInstance().error(trackType, message, param, trackTypeError);
    }
}
