/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.common.pipeline.mongo.domain;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperties;
import com.elitesland.cbpl.logging.common.domain.TrackType;
import com.elitesland.cbpl.tool.db.OrderItem;
import com.elitesland.cbpl.tool.mongo.repository.MongoQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoAuditQuery
extends MongoQuery {
    private static final Logger logger = LoggerFactory.getLogger(MongoAuditQuery.class);
    private static final long serialVersionUID = 156455708394499780L;
    private final AuditQueryParamVO params;

    public String getStoreName() {
        String storeName = LoggingProperties.LOG_AUDIT_CFG.getMongoStoreName();
        logger.debug("[MONGO] query use {}", (Object)storeName);
        return storeName;
    }

    public MongoAuditQuery(AuditQueryParamVO params) {
        OrderItem order = new OrderItem();
        order.setAsc(false);
        order.setColumn("_id");
        super.setOrders(List.of(order));
        super.setCurrent(params.getCurrent());
        super.setSize(params.getSize());
        this.params = params;
    }

    protected Query buildQuery() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"trackType").in(new Object[]{TrackType.LOG_AUDIT.getCode()}));
        if (StrUtil.isNotBlank((CharSequence)this.params.getBizId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"eventParam.bizId").is((Object)this.params.getBizId()));
        }
        if (CollUtil.isNotEmpty(this.params.getBizTypes())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"eventParam.bizType").in(this.params.getBizTypes()));
        }
        return query;
    }

    public static MongoAuditQueryBuilder builder() {
        return new MongoAuditQueryBuilder();
    }

    public String toString() {
        return "MongoAuditQuery(params=" + this.params + ")";
    }

    public static class MongoAuditQueryBuilder {
        private AuditQueryParamVO params;

        MongoAuditQueryBuilder() {
        }

        public MongoAuditQueryBuilder params(AuditQueryParamVO params) {
            this.params = params;
            return this;
        }

        public MongoAuditQuery build() {
            return new MongoAuditQuery(this.params);
        }

        public String toString() {
            return "MongoAuditQuery.MongoAuditQueryBuilder(params=" + this.params + ")";
        }
    }
}

