/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.syslog.controller;

import com.elitesland.cbpl.logging.common.config.LoggingProperties;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.common.util.LogConfigUtil;
import com.elitesland.cbpl.logging.syslog.convert.InstanceConvert;
import com.elitesland.cbpl.logging.syslog.vo.resp.InstanceDetailVO;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65e5\u5fd7\u53c2\u6570\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/logging/system"})
public class SyslogController {
    private static final Logger logger = LoggerFactory.getLogger(SyslogController.class);
    private final PipelineService pipelineService;

    @ApiOperation(value="\u660e\u7ec6\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/details"})
    public HttpResult<PagingVO<InstanceDetailVO>> details(@RequestBody TrackDocQueryParamVO query) {
        logger.info("[LOGGING] syslog details paging param = {}", (Object)query);
        PagingVO result = LogConfigUtil.supply(() -> {
            PagingVO<TrackDocRespVO> docs = this.pipelineService.trackDocPageBy(query);
            List<InstanceDetailVO> records = InstanceConvert.INSTANCE.recordToVO(docs.getRecords());
            return new PagingVO(docs.getTotal(), records);
        }, LoggingProperties.LOG_SYSLOG_CFG);
        return HttpResult.ok((Object)result);
    }

    public SyslogController(PipelineService pipelineService) {
        this.pipelineService = pipelineService;
    }
}

