/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.syslog.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.logging.common.config.LoggingProperties;
import com.elitesland.cbpl.logging.common.constant.TrackType;
import com.elitesland.cbpl.logging.common.domain.LogRecord;
import com.elitesland.cbpl.logging.common.service.PersistenceService;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private static final Logger logger = LoggerFactory.getLogger(LogUtil.class);
    private static PersistenceService persistenceService;

    private static PersistenceService getInstance() {
        if (persistenceService == null) {
            persistenceService = (PersistenceService)SpringUtil.getBean(PersistenceService.class);
        }
        return persistenceService;
    }

    public static void info(String message) {
        LogUtil.info(TrackType.LOG_SYSTEM.getCode(), null, message, null, null);
    }

    public static void info(String bizKey, String message) {
        LogUtil.info(TrackType.LOG_SYSTEM.getCode(), bizKey, message, null, null);
    }

    public static void info(String bizKey, String message, Object param) {
        LogUtil.info(TrackType.LOG_SYSTEM.getCode(), bizKey, message, param, null);
    }

    public static void error(String message, Throwable ex) {
        LogUtil.error(TrackType.LOG_SYSTEM.getCode(), null, message, null, ex, null);
    }

    public static void error(String bizKey, String message, Throwable ex) {
        LogUtil.error(TrackType.LOG_SYSTEM.getCode(), bizKey, message, null, ex, null);
    }

    public static void error(String bizKey, String message, Object param, Throwable ex) {
        LogUtil.error(TrackType.LOG_SYSTEM.getCode(), bizKey, message, param, ex, null);
    }

    public static void info(String trackType, String bizKey, String message, Object param, String traceId) {
        LogUtil.addSystemLogs(trackType, bizKey, message, param, null, traceId);
    }

    public static void error(String trackType, String bizKey, String message, Object param, Throwable ex, String traceId) {
        LogUtil.addSystemLogs(trackType, bizKey, message, param, ExceptionUtils.formatException((Throwable)ex), traceId);
    }

    private static void addSystemLogs(String trackType, String bizKey, String message, Object eventParam, String trackTypeError, String traceId) {
        LogRecord logRecord = new LogRecord();
        logRecord.setBizKey(bizKey);
        logRecord.setTrackType(trackType);
        logRecord.setMessage(message);
        logRecord.setParam(eventParam);
        logRecord.setErrorMessage(trackTypeError);
        LogUtil.getInstance().addSystemLog(LoggingProperties.LOG_SYSLOG_CFG, logRecord);
    }
}

