package com.elitesland.cbpl.logging.audit.annotation.method;

import org.springframework.stereotype.Component;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 声明：该方法为为自定义函数
 *
 * @author eric.hao
 * @since 2023/08/29
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Component
public @interface AuditMethod {

    /**
     * 注册的函数方法命名，便于自定义命名
     *
     * @return 自定义的名字，如果为空即使用 method 的命名
     */
    String value() default "";
}
