package com.elitesland.cbpl.logging.audit.config;

import com.elitesland.cbpl.logging.audit.function.CustomFunctionRegistrar;
import com.elitesland.cbpl.logging.common.config.LoggingProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.logging.common.config.LoggingProperties.LOGGING_PREFIX;

/**
 * @author eric.hao
 * @since 2023/08/29
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(LoggingProperties.class)
@ConditionalOnProperty(prefix = AuditLogAutoConfiguration.AUDIT_LOG_PREFIX, name = "enabled", havingValue = "true")
public class AuditLogAutoConfiguration {

    public static final String AUDIT_LOG_PREFIX = LOGGING_PREFIX + ".audit";

    @Bean
    public CustomFunctionRegistrar registrar() {
        return new CustomFunctionRegistrar();
    }
}
