package com.elitesland.cbpl.logging.common.config;

import com.elitesland.cbpl.logging.common.constant.LogType;
import com.elitesland.cbpl.logging.common.constant.ConsumerPipeline;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;

/**
 * @author eric.hao
 * @since 2023/08/29
 */
@Data
public class LoggingProperty {

    @ApiModelProperty("日志类型")
    @Enumerated(EnumType.STRING)
    private LogType logType;

    @ApiModelProperty("日志记录开关：默认关闭")
    private boolean enabled;

    /**
     * 消费方式（仅指定写入形式，系统需支持对应环境）
     */
    @ApiModelProperty("消费方式")
    @Enumerated(EnumType.STRING)
    private ConsumerPipeline consumerPipeline;

    /**
     * 日志索引名称
     * consumerPipeline='es'时 => 必填
     */
    @ApiModelProperty("日志索引名称")
    private String esIndexName;

    /**
     * 日志索引生命周期策略名称
     * consumerPipeline='es'时 => 选填
     */
    @ApiModelProperty("索引策略")
    private String esPolicyName;

    /**
     * 日志数据库名称
     * consumerPipeline='mongo'时 => 必填
     */
    @ApiModelProperty("日志数据库名称")
    private String mongoStoreName;

    @ApiModelProperty("使用异步线程开关：默认关闭")
    private boolean threadPool;

    @ApiModelProperty("重试机制")
    private RetryProperty retry = new RetryProperty();

    @Data
    public static class RetryProperty {

        @ApiModelProperty("日志处理失败重试次数")
        private int retryTimes = 0;
    }
}
