package com.elitesland.cbpl.logging.common.constant;

import com.elitesland.cbpl.common.base.EnumValues;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @version 0.1.13-SNAPSHOT
 * @since 2023/09/12
 */
@Getter
public enum DeletionStrategy {

    /**
     * 实例删除策略
     */
    NO_DELETION("0", "不删除"),
    DELETION_1("1", "保留近1天"),
    DELETION_2("2", "保留近2天"),
    DELETION_3("3", "保留近3天"),
    DELETION_4("4", "保留近4天"),
    DELETION_5("5", "保留近5天"),
    DELETION_6("6", "保留近6天"),
    DELETION_7("7", "保留近7天"),
    DELETION_15("15", "保留近15天"),
    DELETION_30("30", "保留近30天"),
    DELETION_90("90", "保留近90天"),
    ;

    private final String days;
    private final String desc;

    public String getCode() {
        return this.name();
    }

    DeletionStrategy(String days, String desc) {
        this.days = days;
        this.desc = desc;
    }

    public static String fromDays(String days) {
        for (DeletionStrategy status : DeletionStrategy.values()) {
            if (status.getDays().equals(days)) {
                return status.getDesc();
            }
        }
        return "";
    }

    public static List<EnumValues> enumValues() {
        return Arrays.stream(DeletionStrategy.values())
                .map(name -> EnumValues.of(name.getDays(), name.getDesc()))
                .collect(Collectors.toList());
    }
}
