package com.elitesland.cbpl.logging.common.constant;

import com.elitesland.cbpl.tool.mongo.domain.StoreDef;
import lombok.Getter;

/**
 * @author eric.hao
 * @since 2023/08/29
 */
@Getter
public enum LogType implements StoreDef {

    /**
     * 日志分类
     */
    SYSLOG("系统日志"),
    AUDIT("审计日志"),
    INFINITY("接口日志"),
    TRACK("埋点日志"),
    ;

    private final String desc;

    LogType(String desc) {
        this.desc = desc;
    }

    @Override
    public String getPrefix() {
        return "LOG_";
    }

    public String getCode() {
        return name();
    }
}
