package com.elitesland.cbpl.logging.common.controller;

import com.elitesland.cbpl.common.base.EnumValues;
import com.elitesland.cbpl.logging.common.constant.DeletionStrategy;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/08/07
 * @version 0.1.13-SNAPSHOT
 */
@Slf4j
@Api(tags = "日志参数接口")
@RestController
@RequestMapping("/logging/common")
@RequiredArgsConstructor
public class LoggingController {
    
    @ApiOperation(value = "日志删除策略")
    @GetMapping(value = "/strategy")
    public HttpResult<List<EnumValues>> strategy() {
        return HttpResult.ok(DeletionStrategy.enumValues());
    }
}
