package com.elitesland.cbpl.logging.common.data.service;

import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.common.util.LogConfigUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

import static com.elitesland.cbpl.logging.common.config.LoggingProperties.LOG_AUDIT_CFG;

/**
 * @author eric.hao
 * @since 2024/02/04
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class TrackDocServiceImpl implements TrackDocService {

    private final PipelineService pipelineService;

    @Override
    public List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query) {
        return LogConfigUtil.supply(() -> pipelineService.auditTrackByParam(query), LOG_AUDIT_CFG);
    }
}
