package com.elitesland.cbpl.logging.common.pipeline.mongo.domain;

import com.elitesland.cbpl.logging.common.constant.LogType;
import com.elitesland.cbpl.tool.mongo.domain.MongoDoc;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.time.Instant;
import java.time.temporal.TemporalAccessor;

/**
 * @author eric.hao
 * @since 2024/02/02
 */
@Data
public class MongoTrackDoc implements MongoDoc {

    private static final long serialVersionUID = -7345323383349031571L;

    /**
     * 事件ID
     */
    @Id
    private String id;

    /**
     * 链路ID
     */
    private String traceId;

    /**
     * 请求地址
     */
    private String requestUrl;

    /**
     * 请求方式
     */
    private String requestMethod;

    /**
     * 请求头信息
     */
    private Object requestHeader;

    /**
     * 请求参数：包含查询参数和表单参数
     */
    private Object requestParams;

    /**
     * 请求体信息
     */
    private Object requestBody;

    /**
     * 请求返回信息，字符串类型
     */
    private String responseData;

    /**
     * 业务类型(自定义传值)
     */
    private String trackType;

    /**
     * 业务主键
     */
    private String bizKey;

    /**
     * 创建时间：格式字符串 yyyy-MM-dd HH:mm:ss
     */
    private String createTime;

    /**
     * 客户端IP
     */
    private String addressIp;

    /**
     * 业务记录的日志
     */
    private String eventMessage;

    /**
     * 业务记录的参数
     */
    private Object eventParam;

    /**
     * 错误信息
     */
    private String errorMessage;

    /**
     * 记录时间
     */
    private Instant timestamp = Instant.now();

    /**
     * 扩展对象
     */
    private Object extInfo;

    /**
     * 日志类型
     */
    private LogType type;

    @Override
    public TemporalAccessor getTime() {
        return timestamp;
    }
}
