package com.elitesland.cbpl.logging.common.service;

import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.domain.LogRecord;
import com.elitesland.cbpl.tool.core.http.RequestWrapper;
import com.elitesland.cbpl.unicom.annotation.Unicom;

import java.util.List;

import static com.elitesland.cbpl.tool.core.http.HttpServletUtil.currentRequestWrapper;

/**
 * @author eric.hao
 * @since 2023/08/28
 */
@Unicom
public interface PersistenceService {

    /**
     * 日志持久化操作 - 多条记录分开存储
     *
     * @param property   日志统一配置
     * @param logRecord  业务日志
     * @param eventParam 业务参数(多条)
     */
    <T> void addSystemLogs(LoggingProperty property, LogRecord logRecord, List<T> eventParam);

    /**
     * 日志持久化操作
     *
     * @param property  日志统一配置
     * @param logRecord 业务日志
     */
    default <T> void addSystemLog(LoggingProperty property, LogRecord logRecord) {
        addSystemLog(property, currentRequestWrapper(), logRecord);
    }

    /**
     * 日志持久化操作
     *
     * @param property  日志统一配置
     * @param request   客户端请求
     * @param logRecord 业务日志
     */
    void addSystemLog(LoggingProperty property, RequestWrapper request, LogRecord logRecord);
}
