package com.elitesland.cbpl.logging.common.util;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.lzhpo.tracer.TracerConstants;
import com.lzhpo.tracer.TracerContextFactory;
import com.lzhpo.tracer.util.TracerUtils;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

import java.util.HashMap;

/**
 * @author eric.hao
 * @since 2024/05/28
 */
@Slf4j
public class LogTraceUtil {

    /**
     * 初始化链路ID
     */
    public static void initTraceId() {
        try {
            String traceId = TracerUtils.getTraceId();
            if (StrUtil.isBlank(traceId)) {
                TracerContextFactory tracer = SpringUtil.getBean(TracerContextFactory.class);
                tracer.setContext(new HashMap<>());
            }
        } catch (NoSuchBeanDefinitionException e) {
            logger.warn("[LOGGING] tracer log not enabled.");
        }
    }

    /**
     * 清空上下文
     */
    public static void clearTraceId() {
        MDC.remove(TracerConstants.X_B3_PARENT_SPAN_NAME);
        MDC.remove(TracerConstants.X_B3_SPAN_NAME);
        MDC.remove(TracerConstants.X_B3_TRACE_ID);
        MDC.remove(TracerConstants.X_B3_SPAN_ID);
    }
}
