package com.elitesland.cbpl.logging.syslog.controller;

import com.elitesland.cbpl.logging.syslog.convert.InstanceConvert;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.syslog.vo.resp.InstanceDetailVO;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.common.util.LogConfigUtil;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import static com.elitesland.cbpl.logging.common.config.LoggingProperties.LOG_SYSLOG_CFG;

/**
 * @author eric.hao
 * @since 2024/08/07
 * @version 0.1.13-SNAPSHOT
 */
@Slf4j
@Api(tags = "日志查询接口")
@RestController
@RequestMapping("/logging/system")
@RequiredArgsConstructor
public class SyslogController {

    private final PipelineService pipelineService;
    @ApiOperation(value = "明细分页查询")
    @PostMapping(value = "/details")
    public HttpResult<PagingVO<InstanceDetailVO>> details(@RequestBody TrackDocQueryParamVO query) {
        logger.info("[LOGGING] syslog details paging param = {}", query);
        var result = LogConfigUtil.supply(() -> {
            var docs = pipelineService.trackDocPageBy(query);
            var records = InstanceConvert.INSTANCE.recordToVO(docs.getRecords());
            return new PagingVO<>(docs.getTotal(), records);
        }, LOG_SYSLOG_CFG);
        return HttpResult.ok(result);
    }
}
