package com.elitesland.cbpl.logging.syslog.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 执行日志详细记录
 *
 * @author eric.hao
 * @since 2024/07/12
 */
@Data
@ApiModel("统一日志记录内容")
public class InstanceDetailVO implements Serializable {

    private static final long serialVersionUID = 6364089909872751213L;

    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "业务类型(自定义传值)")
    private String trackType;

    @ApiModelProperty(value = "业务主键")
    private String bizKey;

    @ApiModelProperty(value = "链路ID")
    private String traceId;

    @ApiModelProperty(value = "业务记录的日志")
    private String eventMessage;

    @ApiModelProperty(value = "业务记录的参数")
    private String eventParam;

    @ApiModelProperty(value = "错误信息")
    private String errorMessage;

    @ApiModelProperty(value = "客户端IP")
    private String addressIp;

    @ApiModelProperty(value = "记录创建者ID")
    private Long createUserId;

    @ApiModelProperty(value = "记录创建者")
    private String creator;

    @ApiModelProperty(value = "记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty(value = "记录最后更新者")
    private String updater;

    @ApiModelProperty(value = "记录最后更新时间")
    private LocalDateTime modifyTime;
}
