package com.elitesland.cbpl.rosefinch.tracer;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.rosefinch.util.RosefinchTraceUtil;
import com.lzhpo.tracer.TracerContextCustomizer;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author eric.hao
 * @since 2024/08/08
 */
@Slf4j
@Component
public class CustomizerContext implements TracerContextCustomizer {

    @Override
    public void customize(Map<String, String> context) {
        String bpmnTraceId = MDC.get(RosefinchTraceUtil.X_ROSEFINCH_TRACE_ID);
        if (StrUtil.isBlank(bpmnTraceId)) {
            context.put(RosefinchTraceUtil.X_ROSEFINCH_TRACE_ID, IdUtil.fastSimpleUUID());
        }
    }
}
