package com.elitesland.cbpl.rosefinch.util;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;

/**
 * @author eric.hao
 * @since 2024/05/28
 */
@Slf4j
public class RosefinchTraceUtil {

    public static final String X_ROSEFINCH_TRACE_ID = "X-Rosefinch-TraceId";

    /**
     * 初始化链路ID
     */
    public static void initTraceId() {
        String traceId = MDC.get(X_ROSEFINCH_TRACE_ID);
        if (StrUtil.isBlank(traceId)) {
            MDC.put(X_ROSEFINCH_TRACE_ID, IdUtil.fastSimpleUUID());
        }
    }

    /**
     * 清空上下文
     */
    public static void clearTraceId() {
        MDC.remove(X_ROSEFINCH_TRACE_ID);
    }

    public static String getTraceId() {
        return MDC.get(X_ROSEFINCH_TRACE_ID);
    }
}
