/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.audit.annotation.aspect;

import com.elitesland.cbpl.logging.audit.annotation.AuditLog;
import com.elitesland.cbpl.logging.audit.annotation.aspect.AuditLogHandler;
import com.elitesland.cbpl.logging.audit.context.AuditLogContext;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperties;
import com.elitesland.cbpl.logging.common.constant.TrackType;
import com.elitesland.cbpl.logging.common.domain.LogRecord;
import com.elitesland.cbpl.logging.common.service.PersistenceService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Aspect
@Component
public class AuditLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogAspect.class);
    private final AuditLogHandler auditLogHandler;
    private final PersistenceService persistenceService;

    @Around(value="@annotation(com.elitesland.cbpl.logging.audit.annotation.AuditLog) || @annotation(com.elitesland.cbpl.logging.audit.annotation.AuditLogs)")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        StopWatch stopWatch = null;
        LinkedHashMap<AuditLog, AuditLogVO> auditLogMap = new LinkedHashMap<AuditLog, AuditLogVO>();
        try {
            this.auditLogHandler.executeBeforeFunc(joinPoint, auditLogMap);
            stopWatch = new StopWatch();
            stopWatch.start();
            result = joinPoint.proceed();
            stopWatch.stop();
            this.auditLogHandler.executeAfterFunc(joinPoint, auditLogMap, result);
        }
        catch (Throwable throwable) {
            if (stopWatch != null) {
                stopWatch.stop();
            }
            this.auditLogHandler.executeException(joinPoint, auditLogMap, throwable);
            throw throwable;
        }
        finally {
            try {
                ArrayList auditLogList = new ArrayList(auditLogMap.values());
                LogRecord logRecord = new LogRecord();
                logRecord.setTrackType(TrackType.LOG_AUDIT.getCode());
                logRecord.setMessage("\u4e1a\u52a1\u5ba1\u8ba1\u65e5\u5fd7");
                this.persistenceService.addSystemLogs(LoggingProperties.LOG_AUDIT_CFG, logRecord, auditLogList);
                AuditLogContext.clearContext();
            }
            catch (Throwable throwableFinal) {
                logger.error("[PHOENIX-AUDIT] around final error", throwableFinal);
            }
        }
        return result;
    }

    public AuditLogAspect(AuditLogHandler auditLogHandler, PersistenceService persistenceService) {
        this.auditLogHandler = auditLogHandler;
        this.persistenceService = persistenceService;
    }
}

