/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.audit.annotation.aspect;

import com.elitesland.cbpl.logging.audit.annotation.AuditLog;
import com.elitesland.cbpl.logging.audit.context.AuditLogContext;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.audit.function.CustomFunctionRegistrar;
import com.elitesland.cbpl.logging.audit.spi.AuditLogListener;
import com.elitesland.cbpl.logging.audit.util.ExpressionParser;
import com.elitesland.cbpl.tool.aop.AopAssistant;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
public class AuditLogParse {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogParse.class);
    @Autowired(required=false)
    private AuditLogListener auditLogListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditLogVO resolve(AuditLog annotation, JoinPoint joinPoint) {
        AuditLogVO auditLogVO = null;
        String bizIdSpel = annotation.bizId();
        String bizTypeSpel = annotation.bizType();
        String tagSpel = annotation.tag();
        String msgSpel = annotation.msg();
        String extraSpel = annotation.extra();
        String operatorIdSpel = annotation.operatorId();
        String operatorNameSpel = annotation.operatorName();
        String conditionSpel = annotation.condition();
        String successSpel = annotation.success();
        String bizId = null;
        String bizType = null;
        String tag = null;
        String msg = null;
        String extra = null;
        String operatorId = null;
        String operatorName = null;
        Boolean functionExecuteSuccess = null;
        try {
            boolean conditionPassed;
            StandardEvaluationContext context = AuditLogContext.getContext();
            CustomFunctionRegistrar.register(context);
            Map parameters = AopAssistant.getParameters((JoinPoint)joinPoint);
            parameters.forEach((arg_0, arg_1) -> ((StandardEvaluationContext)context).setVariable(arg_0, arg_1));
            if (StringUtils.isNotBlank((CharSequence)conditionSpel) && !(conditionPassed = ExpressionParser.parseParamToBoolean(conditionSpel, context))) {
                AuditLogVO auditLogVO2 = null;
                return auditLogVO2;
            }
            if (StringUtils.isNotBlank((CharSequence)successSpel)) {
                functionExecuteSuccess = ExpressionParser.parseParamToBoolean(successSpel, context);
            }
            if (StringUtils.isNotBlank((CharSequence)bizIdSpel)) {
                bizId = ExpressionParser.parseParamToString(bizIdSpel, context);
            }
            if (StringUtils.isNotBlank((CharSequence)bizTypeSpel)) {
                bizType = ExpressionParser.parseParamToString(bizTypeSpel, context);
            }
            if (StringUtils.isNotBlank((CharSequence)tagSpel)) {
                tag = ExpressionParser.parseParamToString(tagSpel, context);
            }
            if (StringUtils.isNotBlank((CharSequence)msgSpel)) {
                msg = ExpressionParser.parseParamToStringOrJson(msgSpel, context);
            }
            if (StringUtils.isNotBlank((CharSequence)extraSpel)) {
                extra = ExpressionParser.parseParamToStringOrJson(extraSpel, context);
            }
            if (this.auditLogListener != null) {
                operatorId = this.auditLogListener.getOperatorId();
                operatorName = this.auditLogListener.getOperatorName();
            }
            if (StringUtils.isNotBlank((CharSequence)operatorIdSpel)) {
                operatorId = ExpressionParser.parseParamToString(operatorIdSpel, context);
                operatorName = ExpressionParser.parseParamToString(operatorNameSpel, context);
            }
            auditLogVO = new AuditLogVO();
            auditLogVO.setLogId(UUID.randomUUID().toString());
            auditLogVO.setBizId(bizId);
            auditLogVO.setBizType(bizType);
            auditLogVO.setTag(tag);
            auditLogVO.setOperateDate(new Date());
            auditLogVO.setMessage(msg);
            auditLogVO.setExtra(extra);
            auditLogVO.setOperatorId(operatorId);
            auditLogVO.setOperatorName(operatorName);
            auditLogVO.setSuccess(functionExecuteSuccess);
            auditLogVO.setAuditDiffVOList(AuditLogContext.getDiffVOList());
        }
        catch (Exception e) {
            logger.error("[PHOENIX-AUDIT] resolveExpress error", (Throwable)e);
        }
        finally {
            AuditLogContext.clearDiffVOList();
        }
        return auditLogVO;
    }
}

