/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.common.pipeline.es.service;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocDeleteParamVO;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.tool.es.repository.ElasticsearchRepository;
import com.elitesland.cbpl.tool.es.util.ElasticsearchUtil;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="ES")
public class ElasticsearchPipelineService
implements PipelineService {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchPipelineService.class);
    @Resource
    private ElasticsearchRepository elasticRepository;

    @Override
    public boolean consume(LoggingProperty property, TrackDoc trackDoc) {
        try {
            Assert.notBlank((CharSequence)property.getEsIndexName(), (String)"\u3010ES\u3011\u65e5\u5fd7\u7d22\u5f15(es-index-name)\u672a\u914d\u7f6e", (Object[])new Object[0]);
            String indexName = this.getIndexName(property.getEsIndexName());
            String policy = StrUtil.blankToDefault((CharSequence)property.getEsPolicyName(), (String)"");
            if (this.elasticRepository.createIndex(indexName, policy, property.getEsIndexName())) {
                this.elasticRepository.insert((Object)trackDoc, indexName);
            }
            return true;
        }
        catch (Throwable throwable) {
            logger.error("[LOGGING] persistence es error", throwable);
            return false;
        }
    }

    @Override
    public PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        throw PhoenixException.unexpected((String)"\u6682\u672a\u5b9e\u73b0\uff0c\u656c\u8bf7\u671f\u5f85");
    }

    @Override
    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        throw PhoenixException.unexpected((String)"\u6682\u672a\u5b9e\u73b0\uff0c\u656c\u8bf7\u671f\u5f85");
    }

    @Override
    public long trackDocDelete(TrackDocDeleteParamVO paramVO) {
        throw PhoenixException.unexpected((String)"\u6682\u672a\u5b9e\u73b0\uff0c\u656c\u8bf7\u671f\u5f85");
    }

    @Override
    public List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query) {
        throw PhoenixException.unexpected((String)"\u6682\u672a\u5b9e\u73b0\uff0c\u656c\u8bf7\u671f\u5f85");
    }

    private String getIndexName(String indexName) {
        String tenantCode = TenantSpiUtil.currentTenantCode();
        return StrUtil.isBlank((CharSequence)tenantCode) ? ElasticsearchUtil.indexNameByDay((String)indexName) : ElasticsearchUtil.indexNameByDay((String)indexName, (String)tenantCode);
    }
}

