/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.common.pipeline.mongo.service;

import cn.hutool.core.collection.ListUtil;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocDeleteParamVO;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.common.pipeline.mongo.convert.TrackMongoConvert;
import com.elitesland.cbpl.logging.common.pipeline.mongo.domain.MongoAuditQuery;
import com.elitesland.cbpl.logging.common.pipeline.mongo.domain.MongoTrackDoc;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.tool.mongo.domain.MongoDoc;
import com.elitesland.cbpl.tool.mongo.repository.MongoStorer;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="MONGO")
public class MongoPipelineService
implements PipelineService {
    private static final Logger logger = LoggerFactory.getLogger(MongoPipelineService.class);
    @Autowired(required=false)
    private MongoStorer mongoStorer;
    @Autowired(required=false)
    private MongoTemplate mongoTemplate;

    @Override
    public boolean consume(LoggingProperty property, TrackDoc trackDoc) {
        if (this.mongoStorer == null) {
            logger.error("[LOGGING] MongoDB Incorrect configuration.");
            return false;
        }
        try {
            MongoTrackDoc doc = TrackMongoConvert.INSTANCE.toSaveDoc(trackDoc);
            doc.setType(property.getLogType());
            this.mongoStorer.save((MongoDoc)doc, property.getMongoStoreName());
            return true;
        }
        catch (Throwable throwable) {
            logger.error("[LOGGING] persistence mongodb error", throwable);
            return false;
        }
    }

    @Override
    public PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        throw PhoenixException.unexpected((String)"\u6682\u672a\u5b9e\u73b0\uff0c\u656c\u8bf7\u671f\u5f85");
    }

    @Override
    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        throw PhoenixException.unexpected((String)"\u6682\u672a\u5b9e\u73b0\uff0c\u656c\u8bf7\u671f\u5f85");
    }

    @Override
    public long trackDocDelete(TrackDocDeleteParamVO paramVO) {
        throw PhoenixException.unexpected((String)"\u6682\u672a\u5b9e\u73b0\uff0c\u656c\u8bf7\u671f\u5f85");
    }

    @Override
    public List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query) {
        if (this.mongoTemplate == null) {
            logger.error("[LOGGING] MongoDB Incorrect configuration.");
            return ListUtil.empty();
        }
        List result = MongoAuditQuery.builder().params(query).build().find(this.mongoTemplate, MongoTrackDoc.class);
        return result.stream().map(MongoTrackDoc::getEventParam).map(row -> (AuditLogVO)BeanUtils.toBean((Object)row, AuditLogVO.class)).collect(Collectors.toList());
    }
}

