/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.infinity.service;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.logging.common.config.LoggingProperties;
import com.elitesland.cbpl.logging.common.constant.TrackType;
import com.elitesland.cbpl.logging.common.domain.LogRecord;
import com.elitesland.cbpl.logging.common.service.PersistenceService;
import com.elitesland.cbpl.logging.infinity.domain.InfinityLogVO;
import com.elitesland.cbpl.logging.infinity.service.InfinityTrackService;
import com.elitesland.cbpl.logging.infinity.spi.InfinityLogListener;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import com.elitesland.cbpl.tool.core.http.ResponseWrapper;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Service;

@Service
public class InfinityTrackServiceImpl
implements InfinityTrackService {
    private static final Logger logger = LoggerFactory.getLogger(InfinityTrackServiceImpl.class);
    private final PersistenceService persistenceService;
    @Autowired(required=false)
    private InfinityLogListener infinityLogListener;

    @Override
    public void record(ServerHttpRequest request, ServerHttpResponse response, Object responseBody) {
        ResponseWrapper responseWrapper = HttpServletUtil.wrapper((ServerHttpResponse)response);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("CURRENT_TENANT", TenantSpiUtil.currentTenantCode());
        param.put("RESPONSE_STATUS", responseWrapper.getStatus());
        param.put("RESPONSE_BODY", responseBody);
        LogRecord logRecord = new LogRecord();
        logRecord.setTrackType(TrackType.LOG_INFINITY_PASSIVE.getCode());
        logRecord.setMessage("[INFINITY] \u63a5\u53e3(\u88ab\u52a8)\u8c03\u7528\u65e5\u5fd7");
        logRecord.setParam(param);
        this.persistenceService.addSystemLog(LoggingProperties.LOG_INFINITY_CFG, HttpServletUtil.wrapper((ServerHttpRequest)request), logRecord);
    }

    @Override
    public void record(InfinityLogVO requestParam) {
        String trackType = StrUtil.blankToDefault((CharSequence)requestParam.getBusinessType(), (String)TrackType.LOG_INFINITY_INVOKE.getCode());
        LogRecord logRecord = new LogRecord();
        logRecord.setBizKey(requestParam.getBusinessKey());
        logRecord.setTrackType(trackType);
        logRecord.setMessage("[INFINITY] \u63a5\u53e3(\u4e3b\u52a8)\u8c03\u7528\u65e5\u5fd7");
        logRecord.setParam(requestParam);
        this.persistenceService.addSystemLog(LoggingProperties.LOG_INFINITY_CFG, logRecord);
        if (this.infinityLogListener != null) {
            try {
                boolean result = this.infinityLogListener.createLog(requestParam);
                if (!result) {
                    logger.error("[INFINITY] log listener record failed");
                }
            }
            catch (Exception e) {
                logger.error("[INFINITY] log listener record error: ", (Throwable)e);
            }
        }
    }

    public InfinityTrackServiceImpl(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

