/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.syslog.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.elitesland.cbpl.logging.common.constant.TrackType;
import com.elitesland.cbpl.logging.syslog.domain.SysLogMessage;
import com.elitesland.cbpl.logging.syslog.util.LogUtil;
import com.lzhpo.tracer.util.TracerUtils;

public class LogTrack {
    private static final TransmittableThreadLocal<SysLogMessage> SYS_LOG_MESSAGE = new TransmittableThreadLocal();

    private LogTrack() {
    }

    public static SysLogMessage getMessages() {
        return (SysLogMessage)SYS_LOG_MESSAGE.get();
    }

    public static void init() {
        LogTrack.init(TrackType.LOG_SYSTEM.getCode());
    }

    public static void init(String trackType) {
        trackType = StrUtil.blankToDefault((CharSequence)trackType, (String)TrackType.LOG_SYSTEM.getCode());
        SysLogMessage sysLogMessage = new SysLogMessage();
        sysLogMessage.setTraceId(TracerUtils.getTraceId());
        sysLogMessage.setTrackType(trackType);
        SYS_LOG_MESSAGE.set((Object)sysLogMessage);
    }

    public static void add(String message) {
        SysLogMessage sysLogMessage = LogTrack.getMessages();
        sysLogMessage.add(message);
        SYS_LOG_MESSAGE.set((Object)sysLogMessage);
    }

    public static void commit() {
        SysLogMessage sysLogMessage = LogTrack.getMessages();
        LogUtil.info(sysLogMessage.getTrackType(), null, null, sysLogMessage.getMessages(), null);
        SYS_LOG_MESSAGE.remove();
    }
}

