package com.elitesland.cbpl.logging.audit.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author eric.hao
 * @since 2023/08/29
 */
@Documented
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Repeatable(AuditLogs.class)
public @interface AuditLog {

    /**
     * 业务ID
     * <li>可选</li>
     * <li>SpEL表达式</li>
     */
    String bizId();

    /**
     * 业务类型
     * <li>可选</li>
     * <li>SpEL表达式</li>
     */
    String bizType();

    /**
     * 日志内容
     * <li>可选</li>
     * <li>SpEL表达式</li>
     */
    String msg() default "";

    /**
     * 日志标签
     * <li>可选</li>
     * <li>SpEL表达式</li>
     */
    String tag() default "'operation'";

    /**
     * 额外信息
     * <li>可选</li>
     * <li>SpEL表达式</li>
     */
    String extra() default "";

    /**
     * 操作人ID
     * <li>可选</li>
     * <li>SpEL表达式</li>
     */
    String operatorId() default "";

    /**
     * 切面执行时机
     * <li>true: 执行方法前解析切面逻辑</li>
     * <li>false: 执行方法后解析切面逻辑</li>
     */
    boolean executeBeforeFunc() default false;

    /**
     * 是否记录返回值
     * <li>true: 记录返回值</li>
     * <li>false: 不记录返回值</li>
     */
    boolean recordReturnValue() default false;

    /**
     * 日志记录条件
     * <li>可选</li>
     * <li>SpEL表达式</li>
     */
    String condition() default "'true'";

    /**
     * 自定义方法执行是否成功 用于根据返回体或其他情况下自定义日志实体中的success字段
     * <li>可选</li>
     * <li>SpEL表达式</li>
     */
    String success() default "";
}
