package com.elitesland.cbpl.logging.audit.annotation.field;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 声明：该类参与实体类DIFF
 *
 * @author eric.hao
 * @since 2023/08/29
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface AuditObject {

    /**
     * 类的别名：不填则默认类名
     */
    String alias() default "";

    /**
     * 类中所有字段是否开启DIFF：默认开启
     */
    boolean enableAllFields() default true;
}
