package com.elitesland.cbpl.logging.audit.util;

import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

/**
 * @author eric.hao
 * @since 2023/08/29
 */
@Slf4j
@NoArgsConstructor
public class ExpressionParser {

    private static SpelExpressionParser parser;

    private static SpelExpressionParser getInstance() {
        if (parser == null) {
            parser = new SpelExpressionParser();
        }
        return parser;
    }

    public static boolean parseParamToBoolean(String spel, StandardEvaluationContext context) {
        Expression conditionExpression = getInstance().parseExpression(spel);
        return Boolean.TRUE.equals(conditionExpression.getValue(context, Boolean.class));
    }

    public static String parseParamToString(String spel, StandardEvaluationContext context) {
        Expression bizIdExpression = getInstance().parseExpression(spel);
        return bizIdExpression.getValue(context, String.class);
    }

    public static String parseParamToStringOrJson(String spel, StandardEvaluationContext context) {
        Expression msgExpression = getInstance().parseExpression(spel);
        Object obj = msgExpression.getValue(context, Object.class);
        if (obj != null) {
            return obj instanceof String ? (String) obj : BeanUtils.toJsonStr(obj);
        }
        return null;
    }
}
