package com.elitesland.cbpl.logging.common.domain;

import lombok.Data;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.time.Instant;

/**
 * @author eric.hao
 * @since 2022/10/14
 */
@Data
public class TrackDoc {

    /**
     * 链路ID
     */
    private String traceId;

    /**
     * 请求地址
     */
    private StringBuffer requestUrl;

    /**
     * 请求方式
     */
    private String requestMethod;

    /**
     * 请求头信息
     */
    private Object requestHeader;

    /**
     * 请求参数：包含查询参数和表单参数
     */
    private Object requestParams;

    /**
     * 请求体信息
     */
    private Object requestBody;

    /**
     * 请求返回信息，字符串类型
     */
    private String responseData;

    /**
     * 业务类型(自定义传值)
     */
    private String trackType;

    /**
     * 创建时间：格式字符串 yyyy-MM-dd HH:mm:ss
     */
    private String createTime;

    /**
     * 客户端IP
     */
    private String addressIp;

    /**
     * 业务记录的参数
     */
    private Object eventParam;

    /**
     * 错误信息
     */
    private String errorMessage;

    /**
     * 记录时间
     */
    @Field(name = "@timestamp", type = FieldType.Date, format = DateFormat.date_hour_minute_second_millis)
    private Instant timestamp = Instant.now();
}
