/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.infinity.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.cbpl.logging.common.config.LoggingConfig;
import com.elitesland.cbpl.logging.common.domain.TrackType;
import com.elitesland.cbpl.logging.common.service.PersistenceService;
import com.elitesland.cbpl.logging.infinity.service.InfinityTrackService;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import com.elitesland.cbpl.tool.core.http.ResponseWrapper;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Service;

@Service
public class InfinityTrackServiceImpl
implements InfinityTrackService {
    private static final Logger logger = LoggerFactory.getLogger(InfinityTrackServiceImpl.class);
    private final PersistenceService persistenceService;

    @Override
    public void record(ServerHttpRequest request, ServerHttpResponse response, Object responseBody) {
        SysTenantDTO tenant = TenantSession.getCurrentTenant();
        ResponseWrapper responseWrapper = HttpServletUtil.wrapper((ServerHttpResponse)response);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("CURRENT_TENANT", ObjectUtil.isNull((Object)tenant) ? "-1" : tenant.getId().toString());
        param.put("RESPONSE_STATUS", responseWrapper.getStatus());
        param.put("RESPONSE_BODY", responseBody);
        this.persistenceService.addSystemLog(LoggingConfig.LOG_INFINITY_CFG, HttpServletUtil.wrapper((ServerHttpRequest)request), TrackType.LOG_INFINITY_PASSIVE.getCode(), param, "");
    }

    @Override
    public void record(Object requestParam, Object responseBody) {
        SysTenantDTO tenant = TenantSession.getCurrentTenant();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("CURRENT_TENANT", ObjectUtil.isNull((Object)tenant) ? "-1" : tenant.getId().toString());
        param.put("REQUEST_PARAM", requestParam);
        param.put("RESPONSE_BODY", responseBody);
        this.persistenceService.addSystemLog(LoggingConfig.LOG_INFINITY_CFG, TrackType.LOG_INFINITY_INVOKE.getCode(), param, "");
    }

    public InfinityTrackServiceImpl(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

