package com.elitesland.cbpl.logging.common.service;

import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.tool.core.http.RequestWrapper;
import com.elitesland.cbpl.unicom.annotation.Unicom;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/08/28
 */
@Unicom
public interface PersistenceService {

    /**
     * 日志持久化操作 - 多条记录分开存储
     *
     * @param property   日志统一配置
     * @param event      业务类型(自定义传值)
     * @param params     业务参数(多条)
     * @param eventError 报错日志
     */
    <T> void addSystemLogs(LoggingProperty property, String event, List<T> params, String eventError);

    /**
     * 日志持久化操作
     *
     * @param property   日志统一配置
     * @param event      业务类型(自定义传值)
     * @param param      业务参数
     * @param eventError 报错日志
     */
    void addSystemLog(LoggingProperty property, String event, Object param, String eventError);

    /**
     * 日志持久化操作
     *
     * @param property   日志统一配置
     * @param request    客户端请求
     * @param event      业务类型(自定义传值)
     * @param param      业务参数
     * @param eventError 报错日志
     */
    void addSystemLog(LoggingProperty property, RequestWrapper request, String event, Object param, String eventError);
}
