/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.audit.util;

import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ExpressionParser {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionParser.class);
    private static SpelExpressionParser parser;

    private static SpelExpressionParser getInstance() {
        if (parser == null) {
            parser = new SpelExpressionParser();
        }
        return parser;
    }

    public static boolean parseParamToBoolean(String spel, StandardEvaluationContext context) {
        Expression conditionExpression = ExpressionParser.getInstance().parseExpression(spel);
        return Boolean.TRUE.equals(conditionExpression.getValue((EvaluationContext)context, Boolean.class));
    }

    public static String parseParamToString(String spel, StandardEvaluationContext context) {
        Expression bizIdExpression = ExpressionParser.getInstance().parseExpression(spel);
        return (String)bizIdExpression.getValue((EvaluationContext)context, String.class);
    }

    public static String parseParamToStringOrJson(String spel, StandardEvaluationContext context) {
        Expression msgExpression = ExpressionParser.getInstance().parseExpression(spel);
        Object obj = msgExpression.getValue((EvaluationContext)context, Object.class);
        if (obj != null) {
            return obj instanceof String ? (String)obj : BeanUtils.toJsonStr((Object)obj);
        }
        return null;
    }
}

