/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.common.service;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.cbpl.cloudt.tenant.TenantWrapper;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.audit.spi.AuditLogListener;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.logging.common.service.PersistenceService;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.date.DateUtils;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import com.elitesland.cbpl.tool.core.http.RequestWrapper;
import com.elitesland.cbpl.tool.es.repository.ElasticsearchRepository;
import com.elitesland.cbpl.tool.es.util.ElasticsearchUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="GENERAL")
public class PersistenceServiceImpl
implements PersistenceService {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceServiceImpl.class);
    private static final String LOG_TEMPLATE = "[PHOENIX-LOG] {} \u6682\u4e0d\u652f\u6301{}\u5b58\u50a8.";
    private final TenantWrapper tenantWrapper;
    @Resource
    private ElasticsearchRepository elasticRepository;
    @Autowired(required=false)
    private AuditLogListener auditLogListener;

    @Override
    public <T> void addSystemLogs(LoggingProperty property, String event, List<T> params, String eventError) {
        Consumer<Object> addSystemLog = param -> this.write(property, HttpServletUtil.currentRequestWrapper(), event, param, eventError);
        if (property.isThreadPool()) {
            this.tenantWrapper.runAsync(() -> params.forEach(addSystemLog));
        } else {
            params.forEach(addSystemLog);
        }
    }

    @Override
    public void addSystemLog(LoggingProperty property, String event, Object param, String eventError) {
        this.addSystemLog(property, HttpServletUtil.currentRequestWrapper(), event, param, eventError);
    }

    @Override
    public void addSystemLog(LoggingProperty property, RequestWrapper request, String event, Object param, String eventError) {
        if (property.isThreadPool()) {
            this.tenantWrapper.runAsync(() -> this.write(property, request, event, param, eventError));
        } else {
            this.write(property, request, event, param, eventError);
        }
    }

    private void write(LoggingProperty property, RequestWrapper request, String event, Object param, String eventError) {
        if (ObjectUtil.isNull((Object)((Object)property.getLogType()))) {
            logger.error("[PHOENIX-LOG] EVENT({}) \u65e5\u5fd7\u7c7b\u578b\u672a\u6b63\u786e\u914d\u7f6e\uff1a{}", (Object)event, (Object)property);
            return;
        }
        if (ObjectUtil.isNull((Object)((Object)property.getConsumerPipeline()))) {
            logger.error("[PHOENIX-LOG] EVENT({}) \u65e5\u5fd7\u6d88\u8d39\u65b9\u5f0f\u672a\u6307\u5b9a\uff1a{}", (Object)event, (Object)property);
            return;
        }
        String logType = property.getLogType().getCode();
        String pipeline = property.getConsumerPipeline().getCode();
        if (!property.isEnabled()) {
            logger.info("[PHOENIX-LOG] EVENT({}) {} \u529f\u80fd\u672a\u5f00\u542f.", (Object)event, (Object)logType);
            return;
        }
        TrackDoc trackDoc = new TrackDoc();
        if (ObjectUtil.isNotNull((Object)request)) {
            trackDoc.setRequestUrl(request.getRequestURL());
            trackDoc.setRequestMethod(request.getMethod());
            trackDoc.setRequestHeader(HttpServletUtil.getHeaders((HttpServletRequest)request));
            trackDoc.setRequestParams(HttpServletUtil.getParameters((HttpServletRequest)request));
            trackDoc.setRequestBody(request.getBodyString());
            trackDoc.setAddressIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        }
        trackDoc.setTraceId(TraceContext.traceId());
        trackDoc.setTrackType(event);
        trackDoc.setCreateTime(DateUtils.nowStr());
        trackDoc.setEventParam(param);
        trackDoc.setErrorMessage(eventError);
        int maxRetryTimes = property.getRetry().getRetryTimes();
        boolean iOperationLogGetResult = false;
        if (this.auditLogListener != null) {
            for (int retryTimes = 0; retryTimes <= maxRetryTimes; ++retryTimes) {
                try {
                    if (param instanceof AuditLogVO) {
                        iOperationLogGetResult = this.auditLogListener.createLog((AuditLogVO)param);
                    }
                    if (!iOperationLogGetResult) continue;
                    break;
                }
                catch (Throwable throwable) {
                    logger.error("[PHOENIX-LOG] send auditLog error", throwable);
                }
            }
            if (!iOperationLogGetResult) {
                this.auditLogListener.operationLogGetErrorHandler();
            }
        }
        boolean pipelineServiceResult = false;
        for (int retryTimes = 0; retryTimes <= maxRetryTimes; ++retryTimes) {
            try {
                switch (property.getConsumerPipeline()) {
                    case ES: {
                        try {
                            Assert.notBlank((CharSequence)property.getEsIndexName(), (String)"\u3010ES\u3011\u65e5\u5fd7\u7d22\u5f15(es-index-name)\u672a\u914d\u7f6e", (Object[])new Object[0]);
                            String indexName = this.getIndexName(property.getEsIndexName());
                            String policy = StrUtil.blankToDefault((CharSequence)property.getEsPolicyName(), (String)"");
                            if (this.elasticRepository.createIndex(indexName, policy, property.getEsIndexName())) {
                                this.elasticRepository.insert((Object)trackDoc, indexName);
                            }
                            pipelineServiceResult = true;
                        }
                        catch (Throwable throwable) {
                            logger.error("[PHOENIX-LOG] persistence es error", throwable);
                        }
                        break;
                    }
                    case CONSOLE: {
                        try {
                            logger.info("[PHOENIX-LOG] CONSOLE({}): {}", (Object)event, (Object)BeanUtils.toJsonStr((Object)trackDoc));
                            pipelineServiceResult = true;
                        }
                        catch (Throwable throwable) {
                            logger.error("[PHOENIX-LOG] persistence console error", throwable);
                        }
                        break;
                    }
                    default: {
                        logger.info(LOG_TEMPLATE, (Object)logType, (Object)pipeline);
                    }
                }
                if (!pipelineServiceResult) continue;
                break;
            }
            catch (Throwable throwable) {
                logger.error("[PHOENIX-LOG] send persistence error", throwable);
            }
        }
        if (!pipelineServiceResult && this.auditLogListener != null) {
            this.auditLogListener.pipelineErrorHandler();
        }
    }

    private String getIndexName(String indexName) {
        Optional<SysTenantDTO> tenantDTO = Optional.ofNullable(TenantSession.getCurrentTenant());
        return tenantDTO.map(tenant -> ElasticsearchUtil.indexNameByDay((String)indexName, (String)tenant.getId().toString())).orElseGet(() -> ElasticsearchUtil.indexNameByDay((String)indexName));
    }

    public PersistenceServiceImpl(TenantWrapper tenantWrapper) {
        this.tenantWrapper = tenantWrapper;
    }
}

