package com.elitesland.cbpl.logging.audit.data.controller;

import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.common.util.LogConfigUtil;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import static com.elitesland.cbpl.logging.common.config.LoggingProperties.LOG_AUDIT_CFG;

/**
 * @author eric.hao
 * @since 2024/01/30
 */
@Slf4j
@Api(tags = "日志记录内容")
@RestController
@RequestMapping("/logging")
@AllArgsConstructor
public class AuditTrackController {

    private final PipelineService pipelineService;

    @ApiOperation(value = "审计日志 - 不分页查询")
    @PostMapping(value = "/audit/query")
    public HttpResult<List<AuditLogVO>> query(@RequestBody AuditQueryParamVO query) {
        logger.info("[TrackDoc] audit query list param = {}", query);
        return HttpResult.ok(LogConfigUtil.supply(() -> pipelineService.auditTrackByParam(query), LOG_AUDIT_CFG));
    }
}
