package com.elitesland.cbpl.logging.common.domain;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * @author eric.hao
 * @since 2022/09/14
 */
public enum TrackType implements TrackDef {

    /**
     * 业务类型 - 日志统计
     */
    LOG_SYSTEM("系统日志"),
    LOG_AUDIT("审计日志"),
    // 当前系统 =>调用=> 外部系统
    LOG_INFINITY_INVOKE("接口日志(主动)"),
    // 外部系统 =>调用=> 当前系统
    LOG_INFINITY_PASSIVE("接口日志(被动)"),
    LOG_TRACK("埋点日志"),

    /**
     * 业务类型 - 站内信
     */
    INBOX_INFO("消息"),
    INBOX_TODO("待办"),
    INBOX_WARN("告警"),

    /**
     * 业务类型 - 驱逐登录用户
     */
    EVICT_LOGIN("取消登录"),
    EVICT_RESET("用户重置"),
    ;

    /**
     * 消息类型名
     */
    @Getter
    private final String name;

    TrackType(String name) {
        this.name = name;
    }

    @Override
    public String getCode() {
        return name();
    }

    public static Stream<TrackType> getStoreTypes() {
        return Stream.of(TrackType.values())
                .filter(v -> v.getStoreName() != null);
    }
}
