package com.elitesland.cbpl.logging.syslog.config;

import com.elitesland.cbpl.logging.common.config.LoggingProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.logging.common.config.LoggingProperties.LOGGING_PREFIX;

/**
 * @author eric.hao
 * @since 2024/02/04
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(LoggingProperties.class)
@ConditionalOnProperty(prefix = SysLogConfig.SYS_LOG_PREFIX, name = "enabled", havingValue = "true")
public class SysLogConfig {

    public static final String SYS_LOG_PREFIX = LOGGING_PREFIX + ".syslog";
}
