/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.audit.function;

import com.elitesland.cbpl.logging.audit.annotation.method.AuditMethod;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;

public class CustomFunctionRegistrar
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(CustomFunctionRegistrar.class);
    private ApplicationContext applicationContext;
    private static Map<String, Method> functionMap = new HashMap<String, Method>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Map beanWithAnnotation = applicationContext.getBeansWithAnnotation(AuditMethod.class);
        beanWithAnnotation.values().forEach(component -> {
            Method[] methods = component.getClass().getMethods();
            Object originalClass = CustomFunctionRegistrar.getTarget(component);
            AuditMethod classAuditMethod = originalClass.getClass().getAnnotation(AuditMethod.class);
            StringBuilder prefixName = new StringBuilder(classAuditMethod.value());
            if (StringUtils.hasText((CharSequence)prefixName)) {
                prefixName.append("_");
            }
            if (methods.length > 0) {
                HashMap<Method, AuditMethod> annotationMap = new HashMap<Method, AuditMethod>();
                for (Method method2 : methods) {
                    AuditMethod annotation = (AuditMethod)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method2, AuditMethod.class);
                    if (annotation == null) continue;
                    annotationMap.put(method2, annotation);
                }
                annotationMap.keySet().stream().filter(CustomFunctionRegistrar::isStaticMethod).forEach(method -> {
                    AuditMethod annotation = (AuditMethod)annotationMap.get(method);
                    String registerName = StringUtils.hasText((String)annotation.value()) ? annotation.value() : method.getName();
                    functionMap.put(prefixName + registerName, (Method)method);
                    logger.info("[PHOENIX-AUDIT] register static custom function [{}] as name [{}]", method, (Object)(prefixName + registerName));
                });
                List<Method> nonStaticMethods = annotationMap.keySet().stream().filter(method -> !CustomFunctionRegistrar.isStaticMethod(method)).collect(Collectors.toList());
                try {
                    this.proxy2static(nonStaticMethods, component, originalClass).forEach(staticProxyMethod -> annotationMap.keySet().forEach(method -> {
                        if (Arrays.equals(method.getParameterTypes(), staticProxyMethod.getParameterTypes()) && method.getName().equals(staticProxyMethod.getName())) {
                            AuditMethod annotation = (AuditMethod)annotationMap.get(method);
                            String registerName = StringUtils.hasText((String)annotation.value()) ? annotation.value() : method.getName();
                            functionMap.put(prefixName + registerName, (Method)staticProxyMethod);
                            logger.info("[PHOENIX-AUDIT] register nonstatic custom function [{}] as name [{}]", method, (Object)(prefixName + registerName));
                        }
                    }));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CannotCompileException | NotFoundException e) {
                    logger.error(e.getMessage(), e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private List<Method> proxy2static(List<Method> nonStaticMethods, Object delegate, Object originalClass) throws NotFoundException, CannotCompileException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        CtClass ctClass;
        ClassPool pool = ClassPool.getDefault();
        ClassClassPath classPath = new ClassClassPath(this.getClass());
        pool.insertClassPath((ClassPath)classPath);
        Class<?> targetClass = originalClass.getClass();
        String staticallyClassName = targetClass.getName() + "_Statically";
        Class delegateClass = null;
        try {
            ctClass = pool.get(staticallyClassName);
        }
        catch (Exception e) {
            ctClass = null;
        }
        if (ctClass == null) {
            ctClass = this.constructCtClass(nonStaticMethods, pool, targetClass, staticallyClassName);
            delegateClass = ctClass.toClass();
        } else {
            delegateClass = ctClass.getClass().getClassLoader().loadClass(staticallyClassName);
        }
        Object proxy = delegateClass.getConstructor(targetClass).newInstance(delegate);
        return Arrays.asList(proxy.getClass().getDeclaredMethods());
    }

    private CtClass constructCtClass(List<Method> nonStaticMethods, ClassPool pool, Class<?> targetClass, String staticallyClassName) throws NotFoundException, CannotCompileException {
        CtClass ctClass = pool.makeClass(staticallyClassName);
        ctClass.addInterface(pool.get(Serializable.class.getName()));
        CtField field = new CtField(pool.get(targetClass.getName()), "delegating", ctClass);
        field.setModifiers(12);
        ctClass.addField(field);
        CtConstructor cons = new CtConstructor(new CtClass[]{pool.get(targetClass.getName())}, ctClass);
        cons.setBody("{delegating = $1;}");
        ctClass.addConstructor(cons);
        CtMethod getter = new CtMethod(pool.get(targetClass.getName()), "getDelegating", new CtClass[0], ctClass);
        getter.setModifiers(1);
        getter.setBody("{return delegating;}");
        ctClass.addMethod(getter);
        for (Method declaredMethod : nonStaticMethods) {
            int modifier = declaredMethod.getModifiers();
            String methodName = declaredMethod.getName();
            Class<?> returnType = declaredMethod.getReturnType();
            Class<?>[] parameterType = declaredMethod.getParameterTypes();
            StringBuilder builder = new StringBuilder();
            builder.append(this.chooseModifier(modifier |= 8)).append(" ").append(returnType.getName()).append(" ").append(methodName).append("(");
            StringBuilder params = null;
            for (int i = 0; i < parameterType.length; ++i) {
                builder.append(parameterType[i].getName()).append(" ");
                builder.append("$_").append(i).append(",");
                if (params == null) {
                    params = new StringBuilder();
                }
                params.append("$_").append(i).append(",");
            }
            if (params != null) {
                builder.delete(builder.length() - 1, builder.length());
                params.delete(params.length() - 1, params.length());
            }
            builder.append(")");
            builder.append("{").append("");
            if (!returnType.equals(Void.TYPE)) {
                builder.append("return").append(" ");
            }
            builder.append("delegating.").append(methodName).append("(");
            if (params != null) {
                builder.append((CharSequence)params);
            }
            builder.append(")").append(";");
            builder.append("}");
            CtMethod method = CtMethod.make((String)builder.toString(), (CtClass)ctClass);
            ctClass.addMethod(method);
        }
        return ctClass;
    }

    private String chooseModifier(int modifier) {
        StringBuilder builder = new StringBuilder();
        if ((modifier & 1) == 1) {
            builder.append("public").append(" ");
        }
        if ((modifier & 2) == 2) {
            builder.append("private").append(" ");
        }
        if ((modifier & 4) == 4) {
            builder.append("protected").append(" ");
        }
        if ((modifier & 0x400) == 1024) {
            builder.append("abstract").append(" ");
        }
        if ((modifier & 8) == 8) {
            builder.append("static").append(" ");
        }
        if ((modifier & 0x10) == 16) {
            builder.append("final").append(" ");
        }
        return builder.toString();
    }

    public static void register(StandardEvaluationContext context) {
        functionMap.forEach((arg_0, arg_1) -> ((StandardEvaluationContext)context).registerFunction(arg_0, arg_1));
    }

    public static Object getTarget(Object obj) {
        if (!AopUtils.isAopProxy((Object)obj)) {
            return obj;
        }
        try {
            obj = AopUtils.isJdkDynamicProxy((Object)obj) ? CustomFunctionRegistrar.getJdkDynamicProxyTargetObject(obj) : CustomFunctionRegistrar.getCglibDynamicProxyTargetObject(obj);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return obj;
    }

    private static Object getCglibDynamicProxyTargetObject(Object obj) throws Exception {
        Field h = obj.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(obj);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        return ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
    }

    private static Object getJdkDynamicProxyTargetObject(Object obj) throws Exception {
        Field h = obj.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(obj);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        return ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
    }

    private static boolean isStaticMethod(Method method) {
        if (method == null) {
            return false;
        }
        int modifiers = method.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomFunctionRegistrar)) {
            return false;
        }
        CustomFunctionRegistrar other = (CustomFunctionRegistrar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        return !(this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomFunctionRegistrar;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        return result;
    }

    public String toString() {
        return "CustomFunctionRegistrar(applicationContext=" + this.getApplicationContext() + ")";
    }
}

