/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.audit.data.controller;

import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperties;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.logging.common.util.LogConfigUtil;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65e5\u5fd7\u8bb0\u5f55\u5185\u5bb9"})
@RestController
@RequestMapping(value={"/logging"})
public class AuditTrackController {
    private static final Logger logger = LoggerFactory.getLogger(AuditTrackController.class);
    private final PipelineService pipelineService;

    @ApiOperation(value="\u5ba1\u8ba1\u65e5\u5fd7 - \u4e0d\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/audit/query"})
    public HttpResult<List<AuditLogVO>> query(@RequestBody AuditQueryParamVO query) {
        logger.info("[TrackDoc] audit query list param = {}", (Object)query);
        return HttpResult.ok((Object)LogConfigUtil.supply(() -> this.pipelineService.auditTrackByParam(query), LoggingProperties.LOG_AUDIT_CFG));
    }

    public AuditTrackController(PipelineService pipelineService) {
        this.pipelineService = pipelineService;
    }
}

