/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.common.pipeline.mongo.domain;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.sql.Direction;
import cn.hutool.db.sql.Order;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.common.domain.TrackType;
import com.elitesland.cbpl.tool.mongo.repository.MongoQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoAuditQuery
extends MongoQuery {
    private static final Logger logger = LoggerFactory.getLogger(MongoAuditQuery.class);
    private final AuditQueryParamVO params;

    public String getStoreName() {
        return TrackType.LOG_AUDIT.getStoreName();
    }

    public MongoAuditQuery(AuditQueryParamVO params) {
        Order order = new Order();
        order.setDirection(Direction.DESC);
        order.setField("_id");
        super.setOrder(new Order[]{order});
        super.setPageNumber(params.getPageNumber() + 1);
        super.setPageSize(params.getPageSize());
        this.params = params;
    }

    protected Query buildQuery() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"trackType").in(new Object[]{TrackType.LOG_AUDIT.getCode()}));
        if (StrUtil.isNotBlank((CharSequence)this.params.getBizId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"eventParam.bizId").is((Object)this.params.getBizId()));
        }
        if (CollUtil.isNotEmpty(this.params.getBizTypes())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"eventParam.bizType").in(this.params.getBizTypes()));
        }
        logger.info("[AUDIT-LOG] query: {}", (Object)query);
        return query;
    }

    public static MongoAuditQueryBuilder builder() {
        return new MongoAuditQueryBuilder();
    }

    public String toString() {
        return "MongoAuditQuery(params=" + this.params + ")";
    }

    public static class MongoAuditQueryBuilder {
        private AuditQueryParamVO params;

        MongoAuditQueryBuilder() {
        }

        public MongoAuditQueryBuilder params(AuditQueryParamVO params) {
            this.params = params;
            return this;
        }

        public MongoAuditQuery build() {
            return new MongoAuditQuery(this.params);
        }

        public String toString() {
            return "MongoAuditQuery.MongoAuditQueryBuilder(params=" + this.params + ")";
        }
    }
}

