CREATE TABLE `track_doc` (
    `id` bigint NOT NULL COMMENT '记录唯一ID',
    `trace_id` varchar(128) DEFAULT NULL COMMENT '链路ID',
    `request_url` varchar(255) DEFAULT NULL COMMENT '请求地址',
    `request_method` varchar(64) DEFAULT NULL COMMENT '请求方式',
    `request_header` text DEFAULT NULL COMMENT '请求头信息',
    `request_params` mediumtext DEFAULT NULL COMMENT '请求参数：包含查询参数和表单参数',
    `request_body` mediumtext DEFAULT NULL COMMENT '请求体信息',
    `response_data` mediumtext DEFAULT NULL COMMENT '请求返回信息，字符串类型',
    `track_type` varchar(64) DEFAULT NULL COMMENT '业务类型(自定义传值)',
    `address_ip` varchar(128) DEFAULT NULL COMMENT '客户端IP',
    `event_param` mediumtext DEFAULT NULL COMMENT '业务记录的参数',
    `error_message` mediumtext DEFAULT NULL COMMENT '错误信息',
    `remark` varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id` bigint DEFAULT NULL COMMENT '记录创建者ID',
    `creator` varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time` datetime(6) DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id` bigint DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater` varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time` datetime(6) DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag` int DEFAULT '0' COMMENT '删除标记',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB COMMENT='统一日志记录内容';